import time
import pyautogui
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC

def comment_on_post(driver, comment):
    try:
        if not driver or not comment:
            print("[!] No driver or comment specified.")
            return

        print("[💬] Comment found")

        # Step 1: Click the post to open it
        post_link = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.CSS_SELECTOR, "a[id^='post-title-t3_'][slot='title']"))
        )
        driver.execute_script("arguments[0].click();", post_link)
        print("[🔄] Post opened")
        time.sleep(5)

        # Step 2: Locate and click the comment button
        print("[🖼️] Locating comment button from image...")
        location = pyautogui.locateCenterOnScreen("post_comment.png", confidence=0.85)
        if location:
            pyautogui.moveTo(location)
            pyautogui.click()
            print("[✅] Clicked on comment button via image recognition.")
            time.sleep(2)

            # Step 3: Paste the comment
            pyautogui.write(comment, interval=0.05)
            print("[✏️] Value paste done.")
            time.sleep(1)

            # Step 4: Submit with CTRL+ENTER
            pyautogui.hotkey("ctrl", "enter")
            print("[📤] Comment done.")

            # Step 5: Navigate back to previous page
            driver.back()
            print("[↩️] Returned to previous page.")

        else:
            print("[❌] Comment button image not found on screen.")

    except Exception as e:
        print(f"[❗] Error in post handling: {str(e)}")
