import time
import re
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.common.by import By
from comment_cm import comment_on_post  # Import the comment handling function


def process_command(driver, account, cmd_row):
    ...


def execute_command(driver, account, command):
    try:
        if not driver:
            print(f"[!] Driver not found for {account['profile_name']}.")
            return

        if "read_news" in command:
            if command == "read_news":
                driver.get("https://www.reddit.com/?feed=home")
                time.sleep(5)
                print(f"[✓] {account['profile_name']} visited Reddit Home Feed.")
            elif "_" in command:
                try:
                    parts = command.split("_")
                    steps = int(parts[-1])
                    body = driver.find_element(By.TAG_NAME, "body")
                    for i in range(steps):
                        body.send_keys("j")
                        time.sleep(0.5)
                    print(f"[✓] {account['profile_name']} focused post #{steps} successfully.")
                except Exception as e:
                    print(f"[!] Error focusing post for {account['profile_name']}: {e}")
        else:
            print(f"[!] Unknown command: {command}")

    except Exception as e:
        print(f"[!] Exception executing command for {account['profile_name']}: {e}")

def execute_upvote(driver, account):
    try:
        if not driver:
            return
        time.sleep(2)
        body = driver.find_element(By.TAG_NAME, "body")
        body.send_keys("a")  # 'a' is for upvoting a post on Reddit
        print(f"[👍] {account['profile_name']} liked successfully.")
        time.sleep(1)
    except Exception as e:
        print(f"[!] Upvote failed for {account['profile_name']}: {e}")

def parse_duration(duration_str):
    """
    Parses duration strings like "1hr2m10s" into seconds.
    """
    time_units = {
        "hr": 3600,
        "h": 3600,
        "m": 60,
        "s": 1
    }

    pattern = r"(\d+)(hr|h|m|s)"
    matches = re.findall(pattern, duration_str.lower())
    total_seconds = 0

    for value, unit in matches:
        total_seconds += int(value) * time_units.get(unit, 0)

    return total_seconds

def process_command(driver, account, cmd_row):
    try:
        cmd = cmd_row.get("command_automation", "").strip()
        duration = cmd_row.get("time_duration", "").strip().lower()
        upvote = cmd_row.get("upvote", "").strip().lower()
        comment = cmd_row.get("comment", "").strip()  # Get the comment from the sheet

        if not cmd:
            print(f"[!] Skipping empty command for {account['profile_name']}")
            return

        print(f"[→] Executing command for {account['profile_name']}: {cmd}")
        execute_command(driver, account, cmd)

        if upvote == "y":
            print(f"[↑] Upvote requested for {account['profile_name']} on command: {cmd}")
            time.sleep(2)
            execute_upvote(driver, account)

        # If there's a comment, execute it after the upvote
        if comment:
            print(f"[💬] Comment found for {account['profile_name']}. Processing...")
            comment_on_post(driver, comment)  # Call the comment handler from comment_cm.py

        if duration:
            try:
                seconds = parse_duration(duration)
                print(f"[⏳] Waiting {seconds} seconds for {account['profile_name']}...")
                time.sleep(seconds)
            except Exception as e:
                print(f"[!] Failed to parse duration '{duration}' for {account['profile_name']}: {e}")

    except Exception as e:
        print(f"[!] Error in process_command for {account['profile_name']}: {e}")
__all__ = ['process_command']
