# app.py

from auth import show_auth_menu
import sys
from warming_up import warm_up_accounts

def main():
    while True:
        print("\n" + "=" * 30)
        print(" Reddit Automation Tool ".center(30, ' '))
        print("=" * 30)
        print("1. Authorize Reddit accounts")
        print("2. Load Reddit account (Coming Soon)")
        print("3. Warming up Reddit account (Coming Soon)")
        print("4. Exit")

        try:
            choice = input("\nEnter choice (1-4): ").strip()

            if choice == "1":
                show_auth_menu()
            elif choice == "2":
                print("\n[!] Feature coming soon...")
            elif choice == "3":
                warm_up_accounts()
            elif choice == "4":
                print("\n[✓] Exiting...")
                sys.exit(0)
            else:
                print("\n[!] Invalid choice. Please enter a number between 1 and 4.")
        except KeyboardInterrupt:
            print("\n[!] Stopped by user.")
            sys.exit(1)

if __name__ == "__main__":
    main()
